# -*- coding: utf-8 -*-

import math
import matplotlib.pyplot as plt
from pathlib import Path
from matplotlib import rc
rc('font',**{'family':'sans-serif','sans-serif':['Helvetica']})

def combiination(n, r):
    return math.factorial(n) / math.factorial(r) / math.factorial(n - r)

p_ok = 0.671#0.984
p_ng = 0.190#0.007
p_neutral = 0.139#0.009

def calc_false_rate(N):
    print("#####")
    # i: AにもBにもアサインされなかった数
    # j; 間違ってBにアサインされた数
    # N-i-j: 正しくAにアサインされた数
    p = 0
    for i in range(N):
        for j in range((N - i) // 2 + 1, N - i + 1):
            print(N, i, j, N-i-j)
            p += p_neutral ** i * p_ok ** (N-i-j) * p_ng ** j * combiination(N, i) * combiination(N - i, j)
    return p

def calc_positive_rate(N):
    print("#####")
    # i: AにもBにもアサインされなかった数
    # j; 間違ってBにアサインされた数
    # N-i-j: 正しくAにアサインされた数
    p = 0
    for i in range(N + 1):
        for j in range(0, (N - i + 1) // 2):
            print(N, i, j, N-i-j)
            p += p_neutral ** i * p_ok ** (N-i-j) * p_ng ** j * combiination(N, i) * combiination(N - i, j)
    return p

def calc_neutral_rate(N):
    print("#####")
    # i: AにもBにもアサインされなかった数
    # j; 間違ってBにアサインされた数
    # N-i-j: 正しくAにアサインされた数
    p = 0
    for i in range(N + 1):
        if (N - i)%2 == 1:
            continue
        j = (N - i) // 2
        p += p_neutral ** i * p_ok ** j * p_ng ** j * combiination(N, i) * combiination(N - i, j)
        print(N, i, j, N-i-j)
    return p


def bayes_based_probability(N, N_plasmid):
    return calc_positive_rate(N) * (1 / N_plasmid) / (calc_false_rate(N) * (N_plasmid - 1) * (1 / N_plasmid) + calc_positive_rate(N) * (1 / N_plasmid))

# x = range(1, 10)
# y_F = [calc_false_rate(i) for i in x]
# y_P = [calc_positive_rate(i) for i in x]
# y_N = [calc_neutral_rate(i) for i in x]

# fig, ax1 = plt.subplots()
# # ax2 = ax1.twinx()
# ax1.plot(x, y_F, label="false assignment of read from P1 to P2")
# ax1.plot(x, y_N, label="equal score for P1 and P2")
# ax1.set_yscale("log")
# ax1.set_xlabel("number of bases different between P1 and P2")
# ax1.set_ylabel("probability")
# ax1.legend()
# # ax2.plot(x, y_P)
# # ax2.set_yscale("log")
# plt.savefig(Path(__file__).with_suffix(".svg"))
# plt.show()


# p_F = calc_false_rate(3)
# p_P = calc_positive_rate(3)
# p_N = calc_neutral_rate(3)
# print("XXXXXX")
# print(p_F, p_P, p_N)
# print(sum((p_F, p_P, p_N)))
# # quit()

import numpy as np
fig = plt.figure(figsize=(4, 3))
ax1 = fig.add_subplot(1, 1, 1)
for N_plasmid in range(2, 3):
    N_list = range(1, 6)
    p_list = np.array([bayes_based_probability(N, N_plasmid) for N in N_list])
    error_ratio_list = 1 - p_list ** N_plasmid
    ax1.plot(N_list, error_ratio_list, label=f"# of plasmid={N_plasmid}")
    # for x, y in zip(N_list, error_ratio_list):
    #     if x > 1:
    #         y += 0.001
    #     ax1.text(x, y, f"{y:02.1e}", fontsize=10)

ax1.set_xlabel("number of bases different between plasmids")
ax1.set_ylabel("probability")
# ax1.set_xlim(0.8, 5.8)
ax1.set_ylim(-0.001, 0.45)
ax1.set_title("probability of incorrect classification")
plt.tight_layout()
# plt.legend()
plt.savefig(Path(__file__).stem + "_bayes.svg")
plt.show()

